<?php
  require("connzara.php"); 

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// extend TCPF with custom functions
class MYPDF extends TCPDF {

	// Load table data from file
	public function LoadData($file) {
		// Read file lines
		$lines = file($file);
		$data = array();
		foreach($lines as $line) {
			$data[] = explode(';', chop($line));
		}
		return $data;
	}

	// Colored table
	public function ColoredTable($header,$data) {
		// Colors, line width and bold font
		$this->SetFillColor(43, 53, 148);
		$this->SetTextColor(255);
		$this->SetDrawColor(128, 0, 0);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		// Header
		$w = array(20,120, 40 );
		$num_headers = count($header);
		for($i = 0; $i < $num_headers; ++$i) {
			$this->Cell($w[$i], 7, $header[$i], 1, 0, 'L', 1);
		}
		$this->Ln();
		// Color and font restoration
		$this->SetFillColor(224, 235, 255);
		$this->SetTextColor(0);
		$this->SetFont('');
		// Data
		$fill = 0;
		foreach($data as $row) {
			$this->Cell($w[0], 6, $row[0], 'LR', 0, 'L', $fill);
			$this->Cell($w[1], 6, $row[1], 'LR', 0, 'L', $fill);
			$this->Cell($w[2], 6, $row[2], 'LR', 0, 'L', $fill); 
			$this->Ln();
			$fill=!$fill;
		}
		$this->Cell(array_sum($w), 0, '', 'T');
	}
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$queryk=mysqli_query($con,'SELECT COMPANYNAME,concat(PHYSICALADD," Phone ",PHONE1,"\n",email,"  ",WEB)PHYSICALADD   FROM companyinfo c;');
$rowa=mysqli_fetch_array($queryk); 
 
  
 
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Skeva Tech Ltd');
$pdf->SetTitle('Income Statement');
$pdf->SetSubject(' Income Statement');
$pdf->SetSubject(' Income Statement'); 
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $rowa['COMPANYNAME'] , $rowa['PHYSICALADD'], array(0,64,277), array(0,64,128));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica', '', 12);

// add a page
$pdf->AddPage();  
 
 $cyr=$_SESSION['cyr'];
 $pyr=$cyr-1; 
// column titles
$pdf->Cell(0,10,'STATEMENT OF CASH FLOW ',0,0,'C');
 $pdf->Ln(6); 
  $pdf->Cell(0,10,'YEAR ENDED  '.$_SESSION['cyr'],0,0,'C');
 
  $pdf->Ln(); 
 $pdf->SetFont('helvetica','B',10);
  $pdf->Cell(100,10,'  ');
  $pdf->Cell(30,10,'  ');
  $pdf->Cell(30,10,$pyr,'','','R');
  $pdf->Cell(30,10,$cyr,'','','R');
  
  $pdf->Ln(5); 
  $pdf->Cell(100,10,'  ');
  $pdf->Cell(30,10,'Notes');
  $pdf->Cell(30,10,'Ksh','','','R');
  $pdf->Cell(30,10,'Ksh','','','R');
  
  //Revenues 
  $pdf->Ln(5);
  $pdf->Cell(100,10,'Cash Flow from operating activities:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' '); 
  
  $pdf->SetFont('helvetica','',10);  
  $pdf->Ln(6);
  $pdf->Cell(100,10,'Interest Receipts');
  $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM inctrans i where Year(TrDate)=$pyr and TK in(select if(TK='UDF',concat(TK,id),TK)TK  from incsettings where typ='I') "));
  $pdf->Cell(30,10,number_format(  $inrow['Amount'],2,".",","),'','','R');
  $ptot=$ptot+$inrow['Amount'];
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM inctrans i where Year(TrDate)=$cyr and TK in(select if(TK='UDF',concat(TK,id),TK)TK  from incsettings where typ='I') "));
  $pdf->Cell(30,10,number_format(  $inrow['Amount'],2,".",","),'','','R');
  $ctot=$ctot+$inrow['Amount'];
  
    $pdf->Ln(6);
   $pdf->Cell(100,10,'Interest Payments');
   $pdf->Cell(30,10,' ');
   $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM exptrans i where Year(TrDate)=$pyr and TK='INTEXP'"));
  if(!isset($inrow['Amount']))
 
	 $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT  round( (savint+specint+nonint)*'".$ptot."'*0.01,2) Amount FROM finsettings where yrs=$pyr"));  
	$ptot=$ptot-$inrow['Amount']; 
	  if($inrow['Amount']>0)
	 $inrow['Amount']='('.number_format(  $inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format(  $inrow['Amount'],2,".",",");
    $pdf->Cell(30,10,$inrow['Amount'],'','','R');
    $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM exptrans i where Year(TrDate)=$cyr and TK='INTEXP'"));
  if(!isset($inrow['Amount'])) 
	 $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT  round( (savint+specint+nonint)*'".$ctot."'*0.01,2) Amount FROM finsettings where yrs=$cyr")); 
	 $ctot=$ctot-$inrow['Amount']; 
	  if($inrow['Amount']>0)
	 $inrow['Amount']='('.number_format(  $inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format(  $inrow['Amount'],2,".",",");
    $pdf->Cell(30,10,$inrow['Amount'],'','','R'); 
	
	 $pdf->Ln(6);
   $pdf->Cell(100,10,'Payments to Employees and Suppliers');
   $pdf->Cell(30,10,' ');
   $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
   Amount FROM exptrans i where Year(TrDate)=$pyr and TK in ('SUPEX','PEREXP')")); 
	$ptot=$ptot-$inrow['Amount']; 
	 if($inrow['Amount']>0)
	 $inrow['Amount']='('.number_format(  $inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format(  $inrow['Amount'],2,".",",");
    $pdf->Cell(30,10,$inrow['Amount'],'','','R');
    $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
   Amount FROM exptrans i where Year(TrDate)=$cyr and TK in ('SUPEX','PEREXP')")); 
	 $ctot=$ctot-$inrow['Amount']; 
	 if($inrow['Amount']>0)
	 $inrow['Amount']='('.number_format(  $inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format(  $inrow['Amount'],2,".",",");
     $pdf->Cell(30,10,$inrow['Amount'],'','','R'); 
  
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
   $pktot=$ptot;
   if($ptot<0){
   $pktot=$ptot*-1;
    $pktot= '('.number_format($pktot,2,".",",").')';
   } else $pktot=number_format($pktot,2,".",",");
   $cktot=$ctot;
   if($ctot<0){
   $cktot=$ctot*-1;
    $cktot= '('.number_format($cktot,2,".",",").')';
   } else $cktot=number_format( $cktot,2,".",",");
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Cash Flow from operating activities');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R'); 
   
  
    $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________'); 
   $pdf->Cell(30,10,'______________');
   
 
   //Increase in operating assets
   
   $pdf->SetFont('helvetica','B',10);
   $pdf->Ln(6);
   $pdf->Cell(100,10,'(Increase)/decrease in operating assets:');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'','','','R');
   $pdf->Cell(30,10,'','','','R');
    $ctot=0;  $ptot=0;
   //Increase in prepayments and other receivables TK=RECIN
   $pdf->SetFont('helvetica','',10); 
   $pdf->Ln(6);
  $pdf->Cell(100,10,'prepayments and other receivables');
  $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM custtrans i where Year(TrDate)=$pyr ")); 
  $ptot=$ptot+$inrow['Amount'];  //number_format($inrow['Amount'],2,".",",")
   if($inrow['Amount']<0)
	 $inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM custtrans i where Year(TrDate)=$cyr"));
   $ctot=$ctot+$inrow['Amount']; 
   if($inrow['Amount']<0)
   $inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  //Increase in Loans to Members
   
  
	 
 
 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R'); 
   
     $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
    //operational Expenses
   $pdf->SetFont('helvetica','B',10);
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Increase/(decrease)in operating liabilites:');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'','','','R');
   $pdf->Cell(30,10,'','','','R');
  
    $pktok=0;$ctok=0;
   
   
 
  /*  $pdf->Ln(6);
   $pdf->Cell(100,10,'Risk Bearing Liabilities');
   $pdf->Cell(30,10,' ');
   $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount FROM (
  SELECT CrAmount,DrAmount FROM instranspay c where Year(TrDate)=$pyr union
SELECT CrAmount,DrAmount FROM instrans c where Year(TrDate)=$pyr)k  
      "));
   $pktok= $pktok+$inrow['Amount'];
   if($inrow['Amount']<0)
  $inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))  Amount FROM (
  SELECT CrAmount,DrAmount FROM instrans c where Year(TrDate)=$cyr union
SELECT CrAmount,DrAmount FROM instranspay  c where Year(TrDate)=$cyr)k  "));
  $ctok=$ctok+$inrow['Amount']; 
   if($inrow['Amount']<0)
	 $inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')';
	 else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");

  $pdf->Cell(30,10,$inrow['Amount'],'','','R');  */
  $pdf->Ln(6);
  $pdf->Cell(100,10,'Creditors and accrued');
  $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM vendortrans i where Year(TrDate)=$pyr ")); 
   $pktok= $pktok+$inrow['Amount'];
   if($inrow['Amount']<0)
	$inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM vendortrans i where Year(TrDate)=$cyr "));
   $ctok=$ctok+$inrow['Amount']; 
  if($inrow['Amount']<0)
	$inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
    $pktot= $pktok;
     if( $pktok<0){
   $pktot= $pktok*-1;
    $pktot='('.number_format($pktot,2,".",",").')';
   } else   $pktot=number_format($pktot,2,".",",");
   $cktot=$ctok;
   if($ctok<0){
   $cktot=$ctok*-1;
    $cktot='('.number_format($cktot,2,".",",").')';
   } else   $cktot=number_format($cktot,2,".",",");
   $pdf->Ln(6);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R'); 
   
     $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
   
    $pdf->Ln(6);
   $pdf->Cell(100,10,'Net Cash from operating activities');
   $pdf->Cell(30,10,' ');
    $pktok= $pktok+$ptot;
   $pktot= $pktok;
     if( $pktok<0){
     $pktot= $pktok*-1;
    $pktot='('.number_format($pktot,2,".",",").')';
   } else $pktot=number_format( $pktot,2,".",",");
   
   $ctok=$ctok+$ctot;
   $cktot=$ctok;
   if($ctok<0){
   $cktot=$ctok*-1;
    $cktot='('.number_format($cktot,2,".",",").')';
   } else    $cktot=number_format($cktot,2,".",",");
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R');
     
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Tax Paid');
   $pdf->Cell(30,10,' '); 
    $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM taxpayable i where Year(TrDate)=$pyr ")); 
  $ptot=$ptot-$inrow['Amount'];
   if($inrow['Amount']>0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM taxpayable i where Year(TrDate)=$cyr   "));
   $ctot=$ctot-$inrow['Amount']; 
  if($inrow['Amount']>0)
$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
   
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
    $pktot= $pktok;
     if( $pktok<0){
   $pktot= $pktok*-1;
    $pktot='('.number_format($pktot,2,".",",").')';
   } else   $pktot=number_format($pktot,2,".",",");
   $cktot=$ctok;
   if($ctok<0){
   $cktot=$ctok*-1;
    $cktot='('.number_format($cktot,2,".",",").')';
   } else    $cktot=number_format($cktot,2,".",",");
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Net cash generated from operating activities');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R'); 
   
     $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
   
   //operational Expenses
   $pdf->SetFont('helvetica','B',10);
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Cash flow from Investment activities:');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'','','','R');
   $pdf->Cell(30,10,'','','','R');
   $pvtot=0; $cvtot=0; 
   
   $pdf->SetFont('helvetica','',10);
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Purchase of Property,Plant and Equipment');
   $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$pyr and TK='ASSET' and TRNO in(SELECT  AsId  FROM fxasset f where Typ='PE') ")); 
  $pvtot=$pvtot+$inrow['Amount'];
   if($inrow['Amount']>0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$cyr  and TK='ASSET' and TRNO in(SELECT  AsId  FROM fxasset f where Typ='PE' ) "));
   $cvtot=$cvtot+$inrow['Amount']; 
  if($inrow['Amount']>0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
  $pdf->SetFont('helvetica','',10);
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Proceed on Disposal of Plant and Equipment');
   $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$pyr and TK='ADISP' and TRNO in(SELECT Id FROM fxassettrans  f where TK='ADISP'  and  Year(TrDate)=$pyr) ")); 
  $pvtot=$pvtot-$inrow['Amount'];
   if($inrow['Amount']<0)
	$inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$cyr  and TK='ADISP' and TRNO in(SELECT Id FROM fxassettrans  f where TK='ADISP' and  Year(TrDate)=$cyr) "));
   $cvtot=$cvtot-$inrow['Amount']; 
  if($inrow['Amount']<0)
	$inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
  
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Purchase of intangible asset');
   $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$pyr and TK='ASSET' and TRNO in(SELECT  AsId  FROM fxasset f where Typ='IA' ) ")); 
  $pvtot=$pvtot+$inrow['Amount'];
   if($inrow['Amount']>0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$cyr  and TK='ASSET' and TRNO in(SELECT  AsId  FROM fxasset f where Typ='IA' )   "));
   $cvtot=$cvtot+$inrow['Amount']; 
  if($inrow['Amount']>0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Purchase of financial investments ');
   $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$pyr and TK='INVSDP' ")); 
  $pvtot=$pvtot+$inrow['Amount'];
   if($inrow['Amount']>0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$cyr  and TK='INVSDP' "));
   $cvtot=$cvtot+$inrow['Amount']; 
  if($inrow['Amount']>0)
$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Divident Received');
   $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM invesmenttrans i where Year(TrDate)=$pyr and TK='INVSDV' ")); 
  $pvtot=$pvtot-$inrow['Amount'];
   if($inrow['Amount']<0)
	$inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM invesmenttrans i where Year(TrDate)=$cyr  and TK='INVSDV' "));
   $cvtot=$cvtot-$inrow['Amount']; 
  if($inrow['Amount']<0)
$inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
	
	$pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
    $pktot=$pvtot;
   if($pvtot>0){
   $pktot=$pvtot;
    $pktot= '('.number_format($pktot,2,".",",").')';
   } else $pktot=number_format( $pktot*-1,2,".",",");  
   $cktot=$cvtot;
   if($cvtot>0){
   $cktot=$cvtot;
    $cktot= '('.number_format($cktot,2,".",",").')';
   } else $cktot=number_format( $cktot*-1,2,".",",");  
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Net cash   from investing activities');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R'); 
   
     $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   //operational Expenses
   $pdf->SetFont('helvetica','B',10);
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Cash flow from financing activities:');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'','','','R');
   $pdf->Cell(30,10,'','','','R');
   $pftot=0; $cftot=0;
   
   $pdf->SetFont('helvetica','',10);	
  
   
   
  
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
    $pktot=$pftot;
   if($pvtot<0){
   $pktot=$pktot*-1;
    $pktot= '('.number_format($pktot,2,".",",").')';
   } else $pktot=number_format($pktot,2,".",",");  
   $cktot=$cftot;
   if($cvtot<0){
   $cktot=$cktot*-1;
    $cktot= '('.number_format($cktot,2,".",",").')';
   } else $cktot=number_format( $cktot,2,".",","); 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Net Cash from financing activities');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R'); 
   
     $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   $pctot=0; $cctot=0;
   $pdf->Ln(8);
   $pdf->Cell(100,10,'Net increase in cash and cash equivalent');
   $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$pyr ")); 
  $pctot=$pctot+$inrow['Amount'];
   if($inrow['Amount']<0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)=$cyr   "));
   $cctot=$cctot+$inrow['Amount']; 
  if($inrow['Amount']<0)
$inrow['Amount']='('.number_format($inrow['Amount']*-1,2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
  
  $pdf->Ln(8);
   $pdf->Cell(100,10,'Cash and cash equivalent at beginning of year');
   $pdf->Cell(30,10,' ');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)<$pyr ")); 
  $pctot=$pctot+$inrow['Amount'];
   if($inrow['Amount']>0)
	$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
  Amount FROM cashtrans i where Year(TrDate)<$cyr "));
   $cctot=$cctot+$inrow['Amount']; 
  if($inrow['Amount']>0)
$inrow['Amount']='('.number_format($inrow['Amount'],2,".",",").')'; else
	 $inrow['Amount']=number_format($inrow['Amount'],2,".",",");
  $pdf->Cell(30,10,$inrow['Amount'],'','','R');
  
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
   
    $pktot=$pctot;
   if($pvtot<0){
   $pktot=$pktot*-1;
    $pktot= '('.number_format($pktot,2,".",",").')';
   } else $pktot=number_format($pktot,2,".",",");  
   $cktot=$cctot;
   if($cvtot<0){
   $cktot=$cktot*-1;
    $cktot= '('.number_format($cktot,2,".",",").')';
   } else $cktot=number_format( $cktot,2,".",","); 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Cash and Cash equivalent at the end of year');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,$pktot,'','','R');
   $pdf->Cell(30,10,$cktot,'','','R'); 
   
    $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
    $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'______________');
   $pdf->Cell(30,10,'______________');
 //
 
 $pdf->lastPage(); 
 $query=mysqli_query($con,"SELECT pdfnm FROM tblpdfs t;");
 while($row=mysqli_fetch_array($query)){
	 $filename = $row["pdfnm"].".pdf";
 
if (file_exists($filename)) {
     unlink($filename);
}
}
	 
	  mysqli_query($con,"delete from tblpdfs ;");
	  $query=mysqli_query($con,"SELECT date_format((select if(sysuse='T',TrDate,now()) state from systactive),'pdf_%H%i%S') nname FROM dual ;");
	  $row=mysqli_fetch_array($query); 
	  $nname=$_SERVER['SCRIPT_FILENAME'];
	    $base=basename($_SERVER['PHP_SELF']); 
		$nname=str_replace($base,'', $nname); 
	   $nname=$nname.'pdfs/'.$row['nname'];
	  mysqli_query($con,"insert into tblpdfs(pdfnm)values('".$nname."');"); 
     $pdf->Output($nname.".pdf","I");